﻿----------------------------------------------------------------------------
-- ©Copyright: ViperGTS96®--------------------------------------------------
----------------------------------------------------------------------------
--------------------"The simplest design is the best design." --------------
----------------------------------------------------------------------------
----------------------------------------------------------------------------
realDirtColor_mapLoad = {};

function realDirtColor_mapLoad:loadSettings(xmlFileName)

	local settingsFile = loadXMLFile("realDirtColor_XML", xmlFileName, "realDirtColorSettings");
	if settingsFile ~= nil then
		realDirtColor.simpleMode = Utils.getNoNil(getXMLBool(settingsFile, "settings.simpleMode#enabled"), realDirtColor.simpleMode);
		realDirtColor.maxWheelLimit = Utils.getNoNil(getXMLInt(settingsFile, "settings.independentMode#maxNumOfWheels"), realDirtColor.maxWheelLimit);
		realDirtColor.coldSlowsColor = Utils.getNoNil(getXMLBool(settingsFile, "settings.coldSlowsColor#enabled"), realDirtColor.coldSlowsColor);
		realDirtColor.realTimeSnowMelting = Utils.getNoNil(getXMLBool(settingsFile, "settings.realTimeSnowMelting#enabled"), realDirtColor.realTimeSnowMelting);
		realDirtColor.writeToLog = Utils.getNoNil(getXMLBool(settingsFile, "settings.writeToLog#showVehicles"), realDirtColor.writeToLog);
		realDirtColor.debugging = Utils.getNoNil(getXMLBool(settingsFile, "settings.writeToLog#debugging"), realDirtColor.debugging);
		realDirtColor.speeds.body = Utils.getNoNil(getXMLFloat(settingsFile, "settings.colorSettings.baseSpeed#value"), realDirtColor.speeds.body);
		realDirtColor.speeds.revert = Utils.getNoNil(getXMLFloat(settingsFile, "settings.colorSettings.revertSpeed#value"), realDirtColor.speeds.revert);
		realDirtColor.speeds.body = math.clamp(realDirtColor.speeds.body, 0.0001, 0.01);--Limit the amount
		realDirtColor.speeds.revert = math.clamp(realDirtColor.speeds.revert, 1.5, 100.0);--Limit the amount
		realDirtColor.speeds.wheels = realDirtColor.speeds.body*2;
		realDirtColor.speeds.revertFast = realDirtColor.speeds.revert/2;
		realDirtColor.speeds.white = realDirtColor.speeds.revert/4;
		delete(settingsFile);
	else
		Logging.error(realDirtColor.title..": Cannot find settings");
	end;

	return realDirtColor.simpleMode;
end;

function realDirtColor_mapLoad:loadMap(savegame)

	local settingsFile = getUserProfileAppPath().."modSettings/realDirtColor.xml";

	if not fileExists(settingsFile) then
		copyFile(realDirtColor.modDirectory.."templates/settingsTemplate.xml", settingsFile, false);
	end;

	if g_dedicatedServer == nil then
		local readMeFile = getUserProfileAppPath().."modSettings/realDirtColor_ReadMe.txt";
		if not fileExists(readMeFile) then
			local xmlReadMeSrc = loadXMLFile("readMeTemp_XML", realDirtColor.modDirectory.."templates/readmeTemplate.xml", "readMeTemp");
			local textReadMe = Utils.getNoNil(getXMLString(xmlReadMeSrc, "readMe."..g_languageShort), getXMLString(xmlReadMeSrc, "readMe.en"));
			delete(xmlReadMeSrc);
			if textReadMe ~= nil then
				local readMe = createFile(readMeFile, FileAccess.WRITE);
				fileWrite(readMe, textReadMe);
				delete(readMe);
			end;
		end;
	end;

	local rdcSimpleMode = realDirtColor_mapLoad:loadSettings(settingsFile);

	if rdcSimpleMode then
		print(realDirtColor.title.." running in: Simple Mode' v" .. realDirtColor.version .. " by: "..realDirtColor.author);
	else
		print(realDirtColor.title.." running in: Independent Mode' v" .. realDirtColor.version .. " by: "..realDirtColor.author);
	end;

	----------<Initialize Old Dirt Color>-----------
	local defaultColor, _ = g_currentMission.environment:getDirtColors()
	realDirtColor.colors.dryDirt = {};
	realDirtColor.colors.dryDirt.r, realDirtColor.colors.dryDirt.g, realDirtColor.colors.dryDirt.b  = defaultColor[1], defaultColor[2], defaultColor[3];

	g_currentMission.realDirtColor = {};
	g_currentMission.realDirtColor.colors = realDirtColor.colors;
	g_currentMission.realDirtColor.speeds = realDirtColor.speeds;
	g_currentMission.realDirtColor.simpleMode = realDirtColor.simpleMode;
	g_currentMission.realDirtColor.maxWheelLimit = realDirtColor.maxWheelLimit;

end;

addModEventListener(realDirtColor_mapLoad);